#ifndef SOLID_OBJECTS_INCLUDED
#define SOLID_OBJECTS_INCLUDED

#include "i_pathengine.h"
#include <vector>

class cCoordinateMapping;

class cSolidObjects : public iSolidObjects
{
    std::vector<int32_t*> _bufferPointers;

public:

    ~cSolidObjects();

    void add(const std::vector<int32_t>& pointCoords);    

    void applyCoordinateMapping(const cCoordinateMapping& mapping);

// iSolidObjects interface

    int32_t numberOfConvexSolids() const;
    int32_t convexSolid_Points(int32_t convexSolidIndex) const ;
    void convexSolid_Point(int32_t convexSolidIndex, int32_t pointIndex, int32_t& x, int32_t& y, int32_t& z) const;
    int32_t convexSolid_Attribute(int32_t convexSolidIndex, int32_t attributeIndex) const;
};

#endif
